<?php

App::uses('Lib', 'Utility');


App::uses('Aws', 'Lib');


class ConfigController extends AppController
{

    //public $components = array('Email');

    // public $autoRender = false;
    public $layout = false;

    public $aws;




    public function beforeFilter()
     {



         $this->aws = Aws::getInstance();

     }
    public function phpInfo(){


        $this->autoRender = true;
        echo phpinfo();
    }


    public function view(){
        $this->autoRender = true;

        $this->loadModel('Video');
        $params = $this->params['url'];

        $url_param = key($params);
        $video_id = (int) filter_var($url_param, FILTER_SANITIZE_NUMBER_INT);

        $video_detail = $this->Video->getDetails($video_id);


        //config


        $config_data = array();
        if ( MEDIA_STORAGE == "s3") {
            $result = $this->aws->fileUploadToS3("app/webroot/uploads/images/test.jpg", "png",UPLOADS_FOLDER_URI);

            $config_data['s3'] = $result;
            $this->set('config_data', $config_data);




        }else{

            $this->set('config_data',$config_data);
        }

        $data['config_data'] = $config_data;
        $data['video_detail'] = $video_detail;

        //
        $this->set('data', $data);
        //$this->layout = true;
    }



    public function config()
    {
        $this->autoRender = true;
        $config_data = array();
        if ( MEDIA_STORAGE == "s3") {
            $result = $this->aws->fileUploadToS3("app/webroot/uploads/images/test.jpg", "png",UPLOADS_FOLDER_URI);

        

            $config_data['s3'] = $result;
            $this->set('config_data', $config_data);




        }else{

            $this->set('config_data',$config_data);
        }

    }

    public function setupPrivacyAndPush(){

        $this->loadModel('User');
        $this->loadModel('PrivacySetting');
        $this->loadModel('PushNotification');

        $users = $this->User->getAllUsers();

        foreach($users as $key=>$user){


            $user_id = $user['User']['id'];
            $notification[$key]['likes'] = 1;
            $notification[$key]['comments'] = 1;
            $notification[$key]['new_followers'] = 1;
            $notification[$key]['mentions'] = 1;
            $notification[$key]['direct_messages'] = 1;
            $notification[$key]['video_updates'] = 1;
            $notification[$key]['id'] = $user_id;

            // $this->PushNotification->save($notification);


            $settings[$key]['videos_download'] = 1;
            $settings[$key]['videos_repost'] = 1;
            $settings[$key]['direct_message'] = "everyone";
            $settings[$key]['duet'] = "everyone";
            $settings[$key]['liked_videos'] = "me";
            $settings[$key]['video_comment'] = "everyone";
            $settings[$key]['id'] = $user_id;

            //$this->PrivacySetting->save($settings);

        }

        $this->PushNotification->saveAll($notification);
        $this->PrivacySetting->saveAll($settings);
    }


    function findKey($array, $keySearch)
    {
        foreach ($array as $key => $item) {
            if ($key == $keySearch) {


                return true;
            } elseif (is_array($item) && findKey($item, $keySearch)) {
                return true;
            }
        }
        return false;
    }


    public function showApiSettings(){
        $this->autoRender = false;
        $this->loadModel('ApiSetting');

        $details = $this->ApiSetting->getAll();

        if(count($details) > 0){

            pr($details);

            $API_KEY = $this->findKey($details,"APP_KEY");



            foreach($details as $key=>$detail){

                $title =  $detail["ApiSetting"]['title'];
                $value =  $detail["ApiSetting"]['value'];

                if($title == "API_KEY"){

                    $array[$key]['API_KEY'] = $value;

                }

                if($title == "API_STATUS"){

                    $array[$key]['API_STATUS'] = $value;

                }

            }

            Configure::write(
                'ApiSetting',$array
            );

        }

    }




    function checkDatabaseConnection()
    {


        App::uses('ConnectionManager', 'Model');

        try {
            $connected = ConnectionManager::getDataSource('default');
        } catch (Exception $connectionError) {
            $connected = false;
            $errorMsg = $connectionError->getMessage();
            if (method_exists($connectionError, 'getAttributes')):
                $attributes = $connectionError->getAttributes();

            endif;
        }



        if ($connected && $connected->isConnected()):
            return true;
        else:
            return false;
        endif;


    }


}
?>